/*
 * Decompiled with CFR 0.152.
 */
package com.talpie.linker;

import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Base64;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class AES {
    private static final int KEY_BITS = 256;
    private static final int NONCE_BYTES = 12;
    private static final int TAG_BITS = 128;
    private static final String TRANSFORM = "AES/GCM/NoPadding";
    private final SecretKey ownKey;
    private SecretKey peerKey;
    private final SecureRandom rnd = new SecureRandom();

    public AES() throws Exception {
        KeyGenerator kg = KeyGenerator.getInstance("AES");
        kg.init(256);
        this.ownKey = kg.generateKey();
    }

    public AES(SecretKey key) {
        this.ownKey = key;
    }

    public void setCounterKey(SecretKey key) {
        this.peerKey = key;
    }

    public void setCounterKeyBase64(String b64) {
        this.peerKey = new SecretKeySpec(Base64.getDecoder().decode(b64), "AES");
    }

    public String getKeyBase64() {
        return Base64.getEncoder().encodeToString(this.ownKey.getEncoded());
    }

    public SecretKey getKey() {
        return this.ownKey;
    }

    public byte[] encrypt(byte[] data) throws Exception {
        return this.encrypt(data, null);
    }

    public byte[] encrypt(byte[] data, byte[] aad) throws Exception {
        byte[] nonce = new byte[12];
        this.rnd.nextBytes(nonce);
        Cipher c = Cipher.getInstance(TRANSFORM);
        c.init(1, (Key)this.ownKey, new GCMParameterSpec(128, nonce));
        if (aad != null && aad.length > 0) {
            c.updateAAD(aad);
        }
        byte[] ct = c.doFinal(data);
        byte[] out = new byte[nonce.length + ct.length];
        System.arraycopy(nonce, 0, out, 0, nonce.length);
        System.arraycopy(ct, 0, out, nonce.length, ct.length);
        return out;
    }

    public String encrypt(String plainText) throws Exception {
        return Base64.getEncoder().encodeToString(this.encrypt(plainText.getBytes(StandardCharsets.UTF_8), null));
    }

    public byte[] decrypt(byte[] in) throws Exception {
        return this.decrypt(in, null);
    }

    public byte[] decrypt(byte[] in, byte[] aad) throws Exception {
        if (this.peerKey == null) {
            throw new IllegalStateException("Counter AES key not set");
        }
        if (in.length < 28) {
            throw new IllegalArgumentException("Ciphertext too short");
        }
        byte[] nonce = Arrays.copyOfRange(in, 0, 12);
        byte[] ctTag = Arrays.copyOfRange(in, 12, in.length);
        Cipher c = Cipher.getInstance(TRANSFORM);
        c.init(2, (Key)this.peerKey, new GCMParameterSpec(128, nonce));
        if (aad != null && aad.length > 0) {
            c.updateAAD(aad);
        }
        return c.doFinal(ctTag);
    }

    public String decrypt(String base64CipherText) throws Exception {
        return new String(this.decrypt(Base64.getDecoder().decode(base64CipherText), null), StandardCharsets.UTF_8);
    }

    public static AES fromBase64(String b64Key) {
        return new AES(new SecretKeySpec(Base64.getDecoder().decode(b64Key), "AES"));
    }

    public int encryptedLength(int plainLength) {
        return 12 + plainLength + 16;
    }
}

